<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDispatchRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'complaint_id' => 'required|exists:complaints,id',
            'polsek_id' => 'required|exists:polsek,id',
            'unit_type' => 'required|in:samapta,reskrim,lantas,medis,damkar,sar,other',
            'instructions' => 'nullable|string',
        ];
    }
}
