<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ComplaintResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'ticket_number' => $this->ticket_number,
            'source' => $this->source,
            'caller_phone' => $this->caller_phone,
            'caller_name' => $this->caller_name,
            'description' => $this->description,
            'category' => $this->category,
            'status' => $this->status,
            'priority' => $this->priority,
            'location' => [
                'latitude' => $this->location?->latitude,
                'longitude' => $this->location?->longitude,
                'address' => $this->location?->address,
            ],
            'polsek' => [
                'id' => $this->polsek?->id,
                'name' => $this->polsek?->name,
            ],
            'received_at' => $this->received_at?->toISOString(),
            'created_at' => $this->created_at->toISOString(),
        ];
    }
}
