<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DispatchResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'complaint_id' => $this->complaint_id,
            'unit_type' => $this->unit_type,
            'status' => $this->status,
            'instructions' => $this->instructions,
            'polsek' => [
                'id' => $this->polsek?->id,
                'name' => $this->polsek?->name,
            ],
            'dispatch_units' => $this->whenLoaded('dispatchUnits', function () {
                return $this->dispatchUnits->map(function ($unit) {
                    return [
                        'id' => $unit->id,
                        'officer' => [
                            'id' => $unit->officer?->id,
                            'name' => $unit->officer?->user?->name,
                            'nip' => $unit->officer?->nip,
                        ],
                        'status' => $unit->status,
                    ];
                });
            }),
            'dispatched_at' => $this->dispatched_at?->toISOString(),
            'created_at' => $this->created_at->toISOString(),
        ];
    }
}
