<?php

namespace App\Jobs;

use App\Models\Cctv;
use App\Models\Complaint;
use App\Services\CctvService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CaptureCctvSnapshotJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public Cctv $cctv,
        public ?Complaint $complaint = null
    ) {}

    public function handle(CctvService $cctvService): void
    {
        $cctvService->captureSnapshot($this->cctv, $this->complaint);
    }
}
