<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Analytic extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'polda_id',
        'polres_id',
        'polsek_id',
        'total_complaints',
        'emergency_complaints',
        'non_emergency_complaints',
        'completed_complaints',
        'average_response_time',
        'average_resolution_time',
        'crime_heatmap_data',
        'category_breakdown',
        'hourly_statistics',
    ];

    protected function casts(): array
    {
        return [
            'date' => 'date',
            'crime_heatmap_data' => 'array',
            'category_breakdown' => 'array',
            'hourly_statistics' => 'array',
        ];
    }

    public function polda()
    {
        return $this->belongsTo(Polda::class);
    }

    public function polres()
    {
        return $this->belongsTo(Polres::class);
    }

    public function polsek()
    {
        return $this->belongsTo(Polsek::class);
    }
}
