<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Cctv extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'source',
        'latitude',
        'longitude',
        'address',
        'rtsp_url',
        'stream_url',
        'polda_id',
        'polres_id',
        'polsek_id',
        'status',
        'radius_coverage',
        'has_recording',
        'recording_days',
        'metadata',
    ];

    protected function casts(): array
    {
        return [
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
            'has_recording' => 'boolean',
            'metadata' => 'array',
        ];
    }

    public function polda()
    {
        return $this->belongsTo(Polda::class);
    }

    public function polres()
    {
        return $this->belongsTo(Polres::class);
    }

    public function polsek()
    {
        return $this->belongsTo(Polsek::class);
    }

    public function snapshots()
    {
        return $this->hasMany(CctvSnapshot::class);
    }
}
