<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CctvSnapshot extends Model
{
    use HasFactory;

    protected $fillable = [
        'cctv_id',
        'complaint_id',
        'snapshot_path',
        'snapshot_url',
        'type',
        'captured_at',
        'metadata',
    ];

    protected function casts(): array
    {
        return [
            'captured_at' => 'datetime',
            'metadata' => 'array',
        ];
    }

    public function cctv()
    {
        return $this->belongsTo(Cctv::class);
    }

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }
}
