<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Complaint extends Model
{
    use HasFactory;

    protected $fillable = [
        'ticket_number',
        'source',
        'caller_phone',
        'caller_name',
        'description',
        'category',
        'status',
        'priority',
        'location_id',
        'polda_id',
        'polres_id',
        'polsek_id',
        'operator_id',
        'ai_classification',
        'keywords',
        'received_at',
        'dispatched_at',
        'resolved_at',
    ];

    protected function casts(): array
    {
        return [
            'keywords' => 'array',
            'received_at' => 'datetime',
            'dispatched_at' => 'datetime',
            'resolved_at' => 'datetime',
        ];
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function polda()
    {
        return $this->belongsTo(Polda::class);
    }

    public function polres()
    {
        return $this->belongsTo(Polres::class);
    }

    public function polsek()
    {
        return $this->belongsTo(Polsek::class);
    }

    public function operator()
    {
        return $this->belongsTo(User::class, 'operator_id');
    }

    public function recordings()
    {
        return $this->hasMany(ComplaintRecording::class);
    }

    public function dispatches()
    {
        return $this->hasMany(Dispatch::class);
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class);
    }

    public function coordinations()
    {
        return $this->hasMany(Coordination::class);
    }

    public function cctvSnapshots()
    {
        return $this->hasMany(CctvSnapshot::class);
    }

    public function panicButtonActivations()
    {
        return $this->hasMany(PanicButtonActivation::class);
    }
}
