<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ComplaintRecording extends Model
{
    use HasFactory;

    protected $fillable = [
        'complaint_id',
        'file_path',
        'storage_disk',
        'file_name',
        'file_size',
        'duration',
        'source',
        'recording_id',
        'is_encrypted',
        'recorded_at',
    ];

    protected function casts(): array
    {
        return [
            'is_encrypted' => 'boolean',
            'recorded_at' => 'datetime',
        ];
    }

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }
}
