<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Coordination extends Model
{
    use HasFactory;

    protected $fillable = [
        'complaint_id',
        'type',
        'internal_type',
        'external_type',
        'recipient_name',
        'recipient_phone',
        'recipient_email',
        'message',
        'status',
        'sender_id',
        'sent_at',
        'acknowledged_at',
    ];

    protected function casts(): array
    {
        return [
            'sent_at' => 'datetime',
            'acknowledged_at' => 'datetime',
        ];
    }

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'sender_id');
    }
}
