<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Dispatch extends Model
{
    use HasFactory;

    protected $fillable = [
        'complaint_id',
        'polsek_id',
        'unit_type',
        'status',
        'instructions',
        'dispatcher_id',
        'dispatched_at',
        'accepted_at',
        'completed_at',
        'escalation_level',
        'escalation_reason',
    ];

    protected function casts(): array
    {
        return [
            'dispatched_at' => 'datetime',
            'accepted_at' => 'datetime',
            'completed_at' => 'datetime',
        ];
    }

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }

    public function polsek()
    {
        return $this->belongsTo(Polsek::class);
    }

    public function dispatcher()
    {
        return $this->belongsTo(User::class, 'dispatcher_id');
    }

    public function dispatchUnits()
    {
        return $this->hasMany(DispatchUnit::class);
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class);
    }

    public function fieldReports()
    {
        return $this->hasMany(FieldReport::class);
    }
}
