<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DispatchUnit extends Model
{
    use HasFactory;

    protected $fillable = [
        'dispatch_id',
        'officer_id',
        'status',
        'assigned_at',
        'accepted_at',
        'arrived_at',
        'completed_at',
    ];

    protected function casts(): array
    {
        return [
            'assigned_at' => 'datetime',
            'accepted_at' => 'datetime',
            'arrived_at' => 'datetime',
            'completed_at' => 'datetime',
        ];
    }

    public function dispatch()
    {
        return $this->belongsTo(Dispatch::class);
    }

    public function officer()
    {
        return $this->belongsTo(Officer::class);
    }
}
