<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FieldReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'dispatch_id',
        'officer_id',
        'status',
        'description',
        'photos',
        'videos',
        'digital_signature',
        'signature_hash',
        'signed_at',
        'latitude',
        'longitude',
        'accepted_at',
        'arrived_at',
        'completed_at',
    ];

    protected function casts(): array
    {
        return [
            'photos' => 'array',
            'videos' => 'array',
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
            'accepted_at' => 'datetime',
            'arrived_at' => 'datetime',
            'completed_at' => 'datetime',
            'signed_at' => 'datetime',
        ];
    }

    public function dispatch()
    {
        return $this->belongsTo(Dispatch::class);
    }

    public function officer()
    {
        return $this->belongsTo(Officer::class);
    }
}
