<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class KnowledgeCenter extends Model
{
    use HasFactory;

    protected $table = 'knowledge_center';

    protected $fillable = [
        'title',
        'slug',
        'category',
        'content',
        'excerpt',
        'featured_image',
        'attachments',
        'author_id',
        'is_published',
        'views',
    ];

    protected function casts(): array
    {
        return [
            'attachments' => 'array',
            'is_published' => 'boolean',
        ];
    }

    public function author()
    {
        return $this->belongsTo(User::class, 'author_id');
    }
}
