<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Location extends Model
{
    use HasFactory;

    protected $fillable = [
        'latitude',
        'longitude',
        'tracking_method',
        'cell_id',
        'tower_id',
        'address',
        'village',
        'district',
        'regency',
        'province',
        'postal_code',
        'accuracy',
        'metadata',
    ];

    protected function casts(): array
    {
        return [
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
            'accuracy' => 'decimal:2',
            'metadata' => 'array',
        ];
    }

    public function complaints()
    {
        return $this->hasMany(Complaint::class);
    }
}
