<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Officer extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'nip',
        'rank',
        'unit',
        'unit_type',
        'polda_id',
        'polres_id',
        'polsek_id',
        'phone',
        'vehicle_number',
        'status',
        'current_latitude',
        'current_longitude',
        'last_location_update',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'current_latitude' => 'decimal:8',
            'current_longitude' => 'decimal:8',
            'last_location_update' => 'datetime',
        ];
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function polda()
    {
        return $this->belongsTo(Polda::class);
    }

    public function polres()
    {
        return $this->belongsTo(Polres::class);
    }

    public function polsek()
    {
        return $this->belongsTo(Polsek::class);
    }

    public function dispatchUnits()
    {
        return $this->hasMany(DispatchUnit::class);
    }

    public function fieldReports()
    {
        return $this->hasMany(FieldReport::class);
    }
}
