<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PanicButton extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'name',
        'type',
        'latitude',
        'longitude',
        'address',
        'polda_id',
        'polres_id',
        'polsek_id',
        'status',
        'last_activated_at',
    ];

    protected function casts(): array
    {
        return [
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
            'last_activated_at' => 'datetime',
        ];
    }

    public function polda()
    {
        return $this->belongsTo(Polda::class);
    }

    public function polres()
    {
        return $this->belongsTo(Polres::class);
    }

    public function polsek()
    {
        return $this->belongsTo(Polsek::class);
    }

    public function activations()
    {
        return $this->hasMany(PanicButtonActivation::class);
    }
}
