<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PanicButtonActivation extends Model
{
    use HasFactory;

    protected $fillable = [
        'panic_button_id',
        'complaint_id',
        'activated_at',
        'status',
        'notes',
    ];

    protected function casts(): array
    {
        return [
            'activated_at' => 'datetime',
        ];
    }

    public function panicButton()
    {
        return $this->belongsTo(PanicButton::class);
    }

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }
}
