<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Polsek extends Model
{
    use HasFactory;

    protected $table = 'polsek';

    protected $fillable = [
        'polres_id',
        'code',
        'name',
        'district',
        'village',
        'latitude',
        'longitude',
        'address',
        'phone',
        'email',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
        ];
    }

    public function polres()
    {
        return $this->belongsTo(Polres::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function complaints()
    {
        return $this->hasMany(Complaint::class);
    }

    public function dispatches()
    {
        return $this->hasMany(Dispatch::class);
    }

    public function cctvs()
    {
        return $this->hasMany(Cctv::class);
    }

    public function panicButtons()
    {
        return $this->hasMany(PanicButton::class);
    }

    public function officers()
    {
        return $this->hasMany(Officer::class);
    }
}
