<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cctvs', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->enum('source', ['polri', 'pemda', 'dishub', 'banking', 'private', 'other'])->default('polri');
            $table->decimal('latitude', 10, 8);
            $table->decimal('longitude', 11, 8);
            $table->string('address')->nullable();
            $table->string('rtsp_url');
            $table->string('stream_url')->nullable();
            $table->foreignId('polda_id')->nullable()->constrained('poldas')->onDelete('set null');
            $table->foreignId('polres_id')->nullable()->constrained('polres')->onDelete('set null');
            $table->foreignId('polsek_id')->nullable()->constrained('polsek')->onDelete('set null');
            $table->enum('status', ['active', 'inactive', 'maintenance'])->default('active');
            $table->integer('radius_coverage')->default(100);
            $table->boolean('has_recording')->default(true);
            $table->integer('recording_days')->default(30);
            $table->json('metadata')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cctvs');
    }
};
