<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dispatches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('complaint_id')->constrained('complaints')->onDelete('cascade');
            $table->foreignId('polsek_id')->constrained('polsek')->onDelete('cascade');
            $table->enum('unit_type', ['samapta', 'reskrim', 'lantas', 'medis', 'damkar', 'sar', 'other'])->default('samapta');
            $table->enum('status', ['pending', 'accepted', 'rejected', 'in_progress', 'completed', 'escalated'])->default('pending');
            $table->text('instructions')->nullable();
            $table->foreignId('dispatcher_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('dispatched_at')->nullable();
            $table->timestamp('accepted_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->integer('escalation_level')->default(0);
            $table->text('escalation_reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dispatches');
    }
};
