<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dispatch_units', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dispatch_id')->constrained('dispatches')->onDelete('cascade');
            // Use unsignedBigInteger instead of foreignId to avoid auto-constraint
            // Constraint will be added in a separate migration after officers table is created
            $table->unsignedBigInteger('officer_id')->nullable();
            $table->enum('status', ['assigned', 'accepted', 'rejected', 'in_transit', 'on_scene', 'completed'])->default('assigned');
            $table->timestamp('assigned_at');
            $table->timestamp('accepted_at')->nullable();
            $table->timestamp('arrived_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dispatch_units');
    }
};
