<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('officers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('nip')->unique();
            $table->string('rank')->nullable();
            $table->string('unit')->nullable();
            $table->enum('unit_type', ['samapta', 'reskrim', 'lantas', 'medis', 'damkar', 'sar', 'other'])->default('samapta');
            $table->foreignId('polda_id')->nullable()->constrained('poldas')->onDelete('set null');
            $table->foreignId('polres_id')->nullable()->constrained('polres')->onDelete('set null');
            $table->foreignId('polsek_id')->nullable()->constrained('polsek')->onDelete('set null');
            $table->string('phone')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->enum('status', ['available', 'busy', 'off_duty', 'on_patrol'])->default('available');
            $table->decimal('current_latitude', 10, 8)->nullable();
            $table->decimal('current_longitude', 11, 8)->nullable();
            $table->timestamp('last_location_update')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('officers');
    }
};
