<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('analytics', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->foreignId('polda_id')->nullable()->constrained('poldas')->onDelete('cascade');
            $table->foreignId('polres_id')->nullable()->constrained('polres')->onDelete('cascade');
            $table->foreignId('polsek_id')->nullable()->constrained('polsek')->onDelete('cascade');
            $table->integer('total_complaints')->default(0);
            $table->integer('emergency_complaints')->default(0);
            $table->integer('non_emergency_complaints')->default(0);
            $table->integer('completed_complaints')->default(0);
            $table->decimal('average_response_time', 10, 2)->nullable();
            $table->decimal('average_resolution_time', 10, 2)->nullable();
            $table->json('crime_heatmap_data')->nullable();
            $table->json('category_breakdown')->nullable();
            $table->json('hourly_statistics')->nullable();
            $table->timestamps();
            
            $table->unique(['date', 'polda_id', 'polres_id', 'polsek_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('analytics');
    }
};
