<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coordinations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('complaint_id')->constrained('complaints')->onDelete('cascade');
            $table->enum('type', ['internal', 'external'])->default('internal');
            $table->enum('internal_type', ['operator_polsek', 'polda_polres', 'polres_polsek', 'chat'])->nullable();
            $table->enum('external_type', ['damkar', 'rs', 'bpbd', 'bnpb', 'basarnas', 'dishub', 'pemda'])->nullable();
            $table->string('recipient_name')->nullable();
            $table->string('recipient_phone')->nullable();
            $table->string('recipient_email')->nullable();
            $table->text('message');
            $table->enum('status', ['pending', 'sent', 'acknowledged', 'completed'])->default('pending');
            $table->foreignId('sender_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('acknowledged_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coordinations');
    }
};
