<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cctv_snapshots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cctv_id')->constrained('cctvs')->onDelete('cascade');
            $table->foreignId('complaint_id')->nullable()->constrained('complaints')->onDelete('set null');
            $table->string('snapshot_path');
            $table->string('snapshot_url')->nullable();
            $table->enum('type', ['realtime', 'playback', 'event_triggered'])->default('realtime');
            $table->timestamp('captured_at');
            $table->json('metadata')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cctv_snapshots');
    }
};
