<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['admin', 'polda', 'polres', 'polsek', 'operator', 'petugas'])->default('operator');
            $table->foreignId('polda_id')->nullable()->constrained('poldas')->onDelete('cascade');
            $table->foreignId('polres_id')->nullable()->constrained('polres')->onDelete('cascade');
            $table->foreignId('polsek_id')->nullable()->constrained('polsek')->onDelete('cascade');
            $table->string('phone')->nullable();
            $table->string('nip')->nullable()->unique();
            $table->boolean('is_active')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['polda_id']);
            $table->dropForeign(['polres_id']);
            $table->dropForeign(['polsek_id']);
            $table->dropColumn(['role', 'polda_id', 'polres_id', 'polsek_id', 'phone', 'nip', 'is_active']);
        });
    }
};
