<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('panic_button_activations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('panic_button_id')->constrained('panic_buttons')->onDelete('cascade');
            $table->foreignId('complaint_id')->nullable()->constrained('complaints')->onDelete('set null');
            $table->timestamp('activated_at');
            $table->enum('status', ['active', 'acknowledged', 'resolved'])->default('active');
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('panic_button_activations');
    }
};
