<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add foreign key constraint after locations table is created
        if (Schema::hasTable('locations') && Schema::hasTable('complaints')) {
            Schema::table('complaints', function (Blueprint $table) {
                $table->foreign('location_id')
                    ->references('id')
                    ->on('locations')
                    ->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('complaints', function (Blueprint $table) {
            $table->dropForeign(['location_id']);
        });
    }
};
