<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add foreign key constraint after officers table is created
        if (Schema::hasTable('officers') && Schema::hasTable('dispatch_units')) {
            Schema::table('dispatch_units', function (Blueprint $table) {
                $table->foreign('officer_id')
                    ->references('id')
                    ->on('officers')
                    ->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('dispatch_units', function (Blueprint $table) {
            $table->dropForeign(['officer_id']);
        });
    }
};
