<?php

namespace Database\Seeders;

use App\Models\Cctv;
use App\Models\Polsek;
use Illuminate\Database\Seeder;

class CctvSeeder extends Seeder
{
    public function run(): void
    {
        $polsek = Polsek::where('code', 'POLSEK-GAMBIR')->first();
        
        if ($polsek) {
            Cctv::create([
                'name' => 'CCTV Monas Utara',
                'code' => 'CCTV-MONAS-001',
                'source' => 'polri',
                'latitude' => -6.1751,
                'longitude' => 106.8650,
                'address' => 'Monumen Nasional, Jakarta Pusat',
                'rtsp_url' => 'rtsp://example.com/stream1',
                'polda_id' => $polsek->polres->polda_id,
                'polres_id' => $polsek->polres_id,
                'polsek_id' => $polsek->id,
                'status' => 'active',
                'radius_coverage' => 200,
                'has_recording' => true,
                'recording_days' => 30,
            ]);
        }
    }
}
