<?php

namespace Database\Seeders;

use App\Models\Officer;
use App\Models\User;
use App\Models\Polsek;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class OfficerSeeder extends Seeder
{
    public function run(): void
    {
        $polsek = Polsek::where('code', 'POLSEK-GAMBIR')->first();
        
        if ($polsek) {
            $user = User::create([
                'name' => 'Bripka Budi Santoso',
                'email' => 'budi@polri.go.id',
                'password' => Hash::make('password'),
                'role' => 'petugas',
                'polda_id' => $polsek->polres->polda_id,
                'polres_id' => $polsek->polres_id,
                'polsek_id' => $polsek->id,
                'phone' => '081234567892',
                'nip' => '198001012010011001',
                'is_active' => true,
            ]);

            Officer::create([
                'user_id' => $user->id,
                'nip' => '198001012010011001',
                'rank' => 'Bripka',
                'unit' => 'Unit Samapta',
                'unit_type' => 'samapta',
                'polda_id' => $polsek->polres->polda_id,
                'polres_id' => $polsek->polres_id,
                'polsek_id' => $polsek->id,
                'phone' => '081234567892',
                'status' => 'available',
                'is_active' => true,
            ]);
        }
    }
}
