<?php

namespace Database\Seeders;

use App\Models\PanicButton;
use App\Models\Polsek;
use Illuminate\Database\Seeder;

class PanicButtonSeeder extends Seeder
{
    public function run(): void
    {
        $polsek = Polsek::where('code', 'POLSEK-GAMBIR')->first();
        
        if ($polsek) {
            PanicButton::create([
                'code' => 'PANIC-BANK-001',
                'name' => 'Panic Button Bank BCA Gambir',
                'type' => 'bank',
                'latitude' => -6.1751,
                'longitude' => 106.8650,
                'address' => 'Jl. Medan Merdeka Selatan, Jakarta Pusat',
                'polda_id' => $polsek->polres->polda_id,
                'polres_id' => $polsek->polres_id,
                'polsek_id' => $polsek->id,
                'status' => 'active',
            ]);
        }
    }
}
