<?php

namespace Database\Seeders;

use App\Models\Polda;
use Illuminate\Database\Seeder;

class PoldaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $poldas = [
            [
                'code' => 'POLDAMET',
                'name' => 'Polda Metro Jaya',
                'province' => 'DKI Jakarta',
                'latitude' => -6.2088,
                'longitude' => 106.8456,
                'address' => 'Jl. Jenderal Sudirman No. 55, Jakarta Pusat',
                'phone' => '021-5234000',
                'email' => 'info@poldamet.go.id',
                'is_active' => true,
            ],
            [
                'code' => 'POLDASUMUT',
                'name' => 'Polda Sumatera Utara',
                'province' => 'Sumatera Utara',
                'latitude' => 3.5952,
                'longitude' => 98.6722,
                'address' => 'Jl. Ahmad Yani No. 1, Medan',
                'phone' => '061-4567890',
                'email' => 'info@poldasumut.go.id',
                'is_active' => true,
            ],
            [
                'code' => 'POLDASEL',
                'name' => 'Polda Sumatera Selatan',
                'province' => 'Sumatera Selatan',
                'latitude' => -2.9914,
                'longitude' => 104.7565,
                'address' => 'Jl. Jenderal Sudirman, Palembang',
                'phone' => '0711-352222',
                'email' => 'info@poldasel.go.id',
                'is_active' => true,
            ],
        ];

        foreach ($poldas as $polda) {
            Polda::create($polda);
        }
    }
}
