<?php

namespace Database\Seeders;

use App\Models\Polres;
use App\Models\Polda;
use Illuminate\Database\Seeder;

class PolresSeeder extends Seeder
{
    public function run(): void
    {
        $poldaMetro = Polda::where('code', 'POLDAMET')->first();
        
        if ($poldaMetro) {
            Polres::create([
                'polda_id' => $poldaMetro->id,
                'code' => 'POLRES-JAKPUS',
                'name' => 'Polres Jakarta Pusat',
                'regency' => 'Jakarta Pusat',
                'latitude' => -6.1944,
                'longitude' => 106.8229,
                'address' => 'Jl. Jenderal Sudirman, Jakarta Pusat',
                'phone' => '021-5703011',
                'email' => 'info@polresjakpus.go.id',
                'is_active' => true,
            ]);
        }
    }
}
