<?php

namespace Database\Seeders;

use App\Models\Polsek;
use App\Models\Polres;
use Illuminate\Database\Seeder;

class PolsekSeeder extends Seeder
{
    public function run(): void
    {
        $polresJakpus = Polres::where('code', 'POLRES-JAKPUS')->first();
        
        if ($polresJakpus) {
            Polsek::create([
                'polres_id' => $polresJakpus->id,
                'code' => 'POLSEK-GAMBIR',
                'name' => 'Polsek Gambir',
                'district' => 'Gambir',
                'village' => 'Gambir',
                'latitude' => -6.1751,
                'longitude' => 106.8650,
                'address' => 'Jl. Medan Merdeka Selatan, Jakarta Pusat',
                'phone' => '021-3843344',
                'email' => 'info@polsekgambir.go.id',
                'is_active' => true,
            ]);
        }
    }
}
