<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Polda;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user
        User::create([
            'name' => 'Administrator',
            'email' => 'admin@polri.go.id',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        // Create Polda user
        $polda = Polda::where('code', 'POLDAMET')->first();
        if ($polda) {
            User::create([
                'name' => 'Kepala Polda Metro Jaya',
                'email' => 'kapolda@poldamet.go.id',
                'password' => Hash::make('password'),
                'role' => 'polda',
                'polda_id' => $polda->id,
                'phone' => '081234567890',
                'is_active' => true,
            ]);

            // Create operator user
            User::create([
                'name' => 'Operator Call Center',
                'email' => 'operator@poldamet.go.id',
                'password' => Hash::make('password'),
                'role' => 'operator',
                'polda_id' => $polda->id,
                'phone' => '081234567891',
                'is_active' => true,
            ]);
        }
    }
}
