@extends('layouts.app')

@section('title', 'Analytics & Heatmap')

@section('content')
<div>
    <h2 class="text-3xl font-bold mb-6">Analytics & Heatmap Kriminal</h2>

    <form method="GET" class="mb-6 flex gap-4 items-end">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Mulai</label>
            <input type="date" name="start_date" value="{{ $startDate }}" class="border rounded px-3 py-2">
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Selesai</label>
            <input type="date" name="end_date" value="{{ $endDate }}" class="border rounded px-3 py-2">
        </div>
        <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            Tampilkan
        </button>
    </form>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Ringkasan</h3>
            <dl class="grid grid-cols-2 gap-4">
                <div>
                    <dt class="text-sm text-gray-500">Total Aduan</dt>
                    <dd class="text-2xl font-bold">{{ $stats['total'] }}</dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Emergency</dt>
                    <dd class="text-2xl font-bold text-red-600">{{ $stats['emergency'] }}</dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Non Emergency</dt>
                    <dd class="text-2xl font-bold text-blue-600">{{ $stats['non_emergency'] }}</dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Selesai</dt>
                    <dd class="text-2xl font-bold text-green-600">{{ $stats['completed'] }}</dd>
                </div>
            </dl>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Response Time</h3>
            <dl class="grid grid-cols-2 gap-4">
                <div>
                    <dt class="text-sm text-gray-500">Rata-rata Respon</dt>
                    <dd class="text-2xl font-bold text-orange-600">{{ $responseTimeStats['avg_response_time'] }} mnt</dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Rata-rata Selesai</dt>
                    <dd class="text-2xl font-bold text-purple-600">{{ $responseTimeStats['avg_resolution_time'] }} mnt</dd>
                </div>
            </dl>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h3 class="text-xl font-bold mb-4">Heatmap Lokasi</h3>
        <div id="heatmap" style="height: 400px;"></div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-xl font-bold mb-4">Statistik Jam</h3>
        <div class="grid grid-cols-6 gap-4">
            @foreach($hourlyStats as $hour => $count)
            <div class="text-center p-4 bg-gray-50 rounded">
                <p class="text-sm text-gray-500">{{ str_pad($hour, 2, '0', STR_PAD_LEFT) }}:00</p>
                <p class="text-2xl font-bold">{{ $count }}</p>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    var map = L.map('heatmap').setView([-2.5489, 118.0149], 5);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);

    @foreach($heatmapData as $point)
        L.circle([{{ $point['lat'] }}, {{ $point['lng'] }}], {
            color: 'red',
            fillColor: '#f03',
            fillOpacity: 0.5,
            radius: {{ $point['count'] * 50 }}
        }).addTo(map).bindPopup('Aduan: {{ $point['count'] }}<br>Kategori: {{ $point['category'] }}');
    @endforeach
</script>
@endpush

