@extends('layouts.app')

@section('title', 'Edit Area Code')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Edit Area Code</h2>
            <p class="text-gray-400 text-sm mt-1">Edit kode area</p>
        </div>
        <a href="{{ route('area-codes.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
            ← Kembali
        </a>
    </div>

    <form action="{{ route('area-codes.update', $areaCode) }}" method="POST" class="bg-surface border border-border rounded-xl p-6">
        @csrf
        @method('PUT')

        <div class="space-y-6">
            <!-- Code -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Kode Area *</label>
                <input type="text" name="code" value="{{ old('code', $areaCode->code) }}" required maxlength="10"
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono">
                @error('code')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Area Name -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Nama Area *</label>
                <input type="text" name="area_name" value="{{ old('area_name', $areaCode->area_name) }}" required
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('area_name')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Location -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">District</label>
                    <input type="text" name="district" value="{{ old('district', $areaCode->district) }}"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Regency</label>
                    <input type="text" name="regency" value="{{ old('regency', $areaCode->regency) }}"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Province</label>
                    <input type="text" name="province" value="{{ old('province', $areaCode->province) }}"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <!-- Coordinates -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Latitude *</label>
                    <input type="number" name="latitude" value="{{ old('latitude', $areaCode->latitude) }}" required step="0.000001"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono">
                    @error('latitude')
                    <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Longitude *</label>
                    <input type="number" name="longitude" value="{{ old('longitude', $areaCode->longitude) }}" required step="0.000001"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono">
                    @error('longitude')
                    <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Provider -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Provider</label>
                <select name="provider"
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Pilih Provider</option>
                    <option value="Telkomsel" {{ old('provider', $areaCode->provider) == 'Telkomsel' ? 'selected' : '' }}>Telkomsel</option>
                    <option value="Indosat" {{ old('provider', $areaCode->provider) == 'Indosat' ? 'selected' : '' }}>Indosat</option>
                    <option value="XL" {{ old('provider', $areaCode->provider) == 'XL' ? 'selected' : '' }}>XL</option>
                    <option value="Tri" {{ old('provider', $areaCode->provider) == 'Tri' ? 'selected' : '' }}>Tri</option>
                </select>
            </div>

            <!-- Submit -->
            <div class="flex gap-3 pt-4">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition">
                    Update Area Code
                </button>
                <a href="{{ route('area-codes.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-6 py-2 rounded-lg transition">
                    Batal
                </a>
            </div>
        </div>
    </form>
</div>
@endsection

