@extends('layouts.app')

@section('title', 'Area Codes')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Area Codes</h2>
            <p class="text-gray-400 text-sm mt-1">Database kode area Indonesia</p>
        </div>
        <a href="{{ route('area-codes.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition flex items-center gap-2">
            <i data-lucide="plus" class="w-4 h-4"></i>
            Tambah Area Code
        </a>
    </div>

    <!-- Filters & Search -->
    <div class="bg-surface border border-border rounded-xl p-4 mb-6">
        <form method="GET" action="{{ route('area-codes.index') }}" class="flex gap-4 flex-wrap">
            <input type="text" name="search" value="{{ request('search') }}" 
                   placeholder="Cari kode area, nama area..." 
                   class="flex-1 min-w-[200px] bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
            <select name="province" class="bg-white/5 border border-white/10 rounded-lg px-3 py-2 text-sm text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Semua Provinsi</option>
                @foreach(\App\Models\AreaCode::distinct()->pluck('province')->filter() as $prov)
                <option value="{{ $prov }}" {{ request('province') == $prov ? 'selected' : '' }}>{{ $prov }}</option>
                @endforeach
            </select>
            <select name="provider" class="bg-white/5 border border-white/10 rounded-lg px-3 py-2 text-sm text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Semua Provider</option>
                <option value="Telkomsel" {{ request('provider') == 'Telkomsel' ? 'selected' : '' }}>Telkomsel</option>
                <option value="Indosat" {{ request('provider') == 'Indosat' ? 'selected' : '' }}>Indosat</option>
                <option value="XL" {{ request('provider') == 'XL' ? 'selected' : '' }}>XL</option>
                <option value="Tri" {{ request('provider') == 'Tri' ? 'selected' : '' }}>Tri</option>
            </select>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Filter
            </button>
            <a href="{{ route('area-codes.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
                Reset
            </a>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-surface border border-border rounded-xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-white/5">
                <thead class="bg-white/5">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Code</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Area Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">District</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Regency</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Province</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Provider</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Coordinates</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-surface divide-y divide-white/5">
                    @forelse($areaCodes as $areaCode)
                    <tr class="hover:bg-white/5 transition">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm font-mono text-blue-400">{{ $areaCode->code }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-white">{{ $areaCode->area_name }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">{{ $areaCode->district ?? '-' }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">{{ $areaCode->regency ?? '-' }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">{{ $areaCode->province ?? '-' }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($areaCode->provider)
                            <span class="px-2 py-1 bg-purple-500/20 text-purple-400 text-xs rounded-full border border-purple-500/30">
                                {{ $areaCode->provider }}
                            </span>
                            @else
                            <span class="text-gray-500 text-xs">-</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-500 font-mono text-xs">
                                {{ number_format($areaCode->latitude, 6) }}, {{ number_format($areaCode->longitude, 6) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex gap-2">
                                <a href="{{ route('area-codes.show', $areaCode) }}" 
                                   class="text-blue-400 hover:text-blue-300 transition">Detail</a>
                                <a href="{{ route('area-codes.edit', $areaCode) }}" 
                                   class="text-green-400 hover:text-green-300 transition">Edit</a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="px-6 py-8 text-center text-gray-400">
                            <div class="flex flex-col items-center gap-2">
                                <i data-lucide="map-pin" class="w-12 h-12 text-gray-600"></i>
                                <p>Tidak ada area codes</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if(method_exists($areaCodes, 'links'))
    <div class="mt-4">
        {{ $areaCodes->links() }}
    </div>
    @endif
</div>

@push('scripts')
<script>
    if (window.lucide) {
        lucide.createIcons();
    }
</script>
@endpush
@endsection

