@extends('layouts.app')

@section('title', 'Area Code Detail')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">{{ $areaCode->code }} - {{ $areaCode->area_name }}</h2>
            <p class="text-gray-400 text-sm mt-1">Detail area code</p>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('area-codes.edit', $areaCode) }}" 
               class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Edit
            </a>
            <a href="{{ route('area-codes.index') }}" 
               class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
                ← Kembali
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Informasi Area</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Kode Area</span>
                        <span class="text-white font-mono text-lg">{{ $areaCode->code }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Nama Area</span>
                        <span class="text-white">{{ $areaCode->area_name }}</span>
                    </div>
                    @if($areaCode->district)
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">District</span>
                        <span class="text-white">{{ $areaCode->district }}</span>
                    </div>
                    @endif
                    @if($areaCode->regency)
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Regency</span>
                        <span class="text-white">{{ $areaCode->regency }}</span>
                    </div>
                    @endif
                    @if($areaCode->province)
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Province</span>
                        <span class="text-white">{{ $areaCode->province }}</span>
                    </div>
                    @endif
                    @if($areaCode->provider)
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Provider</span>
                        <span class="px-3 py-1 bg-purple-500/20 text-purple-400 text-sm rounded-full border border-purple-500/30">
                            {{ $areaCode->provider }}
                        </span>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Coordinates -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Koordinat</h3>
                <div class="space-y-2">
                    <div class="flex justify-between items-center">
                        <span class="text-gray-400">Latitude</span>
                        <span class="text-white font-mono">{{ number_format($areaCode->latitude, 8) }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-400">Longitude</span>
                        <span class="text-white font-mono">{{ number_format($areaCode->longitude, 8) }}</span>
                    </div>
                    <div class="mt-4">
                        <a href="https://www.google.com/maps?q={{ $areaCode->latitude }},{{ $areaCode->longitude }}" 
                           target="_blank"
                           class="inline-flex items-center gap-2 text-blue-400 hover:text-blue-300 text-sm">
                            <i data-lucide="map-pin" class="w-4 h-4"></i>
                            Buka di Google Maps
                        </a>
                    </div>
                </div>
            </div>

            <!-- Map Preview -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Peta Lokasi</h3>
                <div id="map" class="w-full h-64 rounded-lg"></div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Metadata -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Metadata</h3>
                <div class="space-y-4">
                    <div>
                        <p class="text-gray-400 text-sm">Created</p>
                        <p class="text-white text-sm">{{ $areaCode->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-gray-400 text-sm">Updated</p>
                        <p class="text-white text-sm">{{ $areaCode->updated_at->format('d/m/Y H:i') }}</p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Actions</h3>
                <div class="space-y-2">
                    <a href="{{ route('area-codes.edit', $areaCode) }}" 
                       class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                        Edit Area Code
                    </a>
                    <form action="{{ route('area-codes.destroy', $areaCode) }}" method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus area code ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="block w-full bg-red-600 hover:bg-red-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                            Hapus Area Code
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    if (document.getElementById('map')) {
        var map = L.map('map').setView([{{ $areaCode->latitude }}, {{ $areaCode->longitude }}], 13);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; OpenStreetMap'
        }).addTo(map);
        
        var marker = L.marker([{{ $areaCode->latitude }}, {{ $areaCode->longitude }}]).addTo(map)
            .bindPopup('{{ $areaCode->area_name }}');
    }
    
    if (window.lucide) {
        lucide.createIcons();
    }
</script>
@endpush
@endsection

