@extends('layouts.app')

@section('title', 'Tambah Automation Rule')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Tambah Automation Rule</h2>
            <p class="text-gray-400 text-sm mt-1">Buat aturan automasi baru</p>
        </div>
        <a href="{{ route('automation-rules.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
            ← Kembali
        </a>
    </div>

    <form action="{{ route('automation-rules.store') }}" method="POST" class="bg-surface border border-border rounded-xl p-6">
        @csrf

        <div class="space-y-6">
            <!-- Basic Info -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Nama Rule *</label>
                <input type="text" name="name" value="{{ old('name') }}" required
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('name')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Deskripsi</label>
                <textarea name="description" rows="2"
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description') }}</textarea>
            </div>

            <!-- Trigger Event -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Trigger Event *</label>
                <select name="trigger_event" required
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Pilih Trigger Event</option>
                    <option value="complaint.created" {{ old('trigger_event') == 'complaint.created' ? 'selected' : '' }}>Complaint Created</option>
                    <option value="dispatch.no_response" {{ old('trigger_event') == 'dispatch.no_response' ? 'selected' : '' }}>Dispatch No Response</option>
                    <option value="dispatch.accepted" {{ old('trigger_event') == 'dispatch.accepted' ? 'selected' : '' }}>Dispatch Accepted</option>
                    <option value="panic_button.activated" {{ old('trigger_event') == 'panic_button.activated' ? 'selected' : '' }}>Panic Button Activated</option>
                </select>
                @error('trigger_event')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Conditions -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Conditions (JSON) *</label>
                <textarea name="conditions" rows="6" required
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='{"priority": "critical"}'>{{ old('conditions', '{}') }}</textarea>
                <p class="text-gray-500 text-xs mt-1">Format JSON. Contoh: {"priority": "critical", "has_location": true}</p>
                @error('conditions')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Actions -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Actions (JSON Array) *</label>
                <textarea name="actions" rows="4" required
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='["auto_dispatch", "notify_supervisor"]'>{{ old('actions', '[]') }}</textarea>
                <p class="text-gray-500 text-xs mt-1">Format JSON Array. Contoh: ["auto_dispatch", "capture_cctv", "notify_supervisor"]</p>
                @error('actions')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Action Params -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Action Parameters (JSON, Optional)</label>
                <textarea name="action_params" rows="4"
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='{"reason": "Auto-escalation"}'>{{ old('action_params', '{}') }}</textarea>
            </div>

            <!-- Priority & Status -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Priority (0-100)</label>
                    <input type="number" name="priority" value="{{ old('priority', 0) }}" min="0" max="100"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Status</label>
                    <select name="is_active"
                            class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="1" {{ old('is_active', true) ? 'selected' : '' }}>Aktif</option>
                        <option value="0" {{ !old('is_active', true) ? 'selected' : '' }}>Nonaktif</option>
                    </select>
                </div>
            </div>

            <!-- Submit -->
            <div class="flex gap-3 pt-4">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition">
                    Simpan Rule
                </button>
                <a href="{{ route('automation-rules.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-6 py-2 rounded-lg transition">
                    Batal
                </a>
            </div>
        </div>
    </form>
</div>
@endsection

