@extends('layouts.app')

@section('title', 'Automation Rule Detail')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">{{ $automationRule->name }}</h2>
            <p class="text-gray-400 text-sm mt-1">Detail automation rule</p>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('automation-rules.edit', $automationRule) }}" 
               class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Edit
            </a>
            <a href="{{ route('automation-rules.index') }}" 
               class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
                ← Kembali
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Informasi Dasar</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Nama</span>
                        <span class="text-white">{{ $automationRule->name }}</span>
                    </div>
                    @if($automationRule->description)
                    <div class="flex justify-between items-start py-2 border-b border-white/5">
                        <span class="text-gray-400">Deskripsi</span>
                        <span class="text-white text-right">{{ $automationRule->description }}</span>
                    </div>
                    @endif
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Status</span>
                        @if($automationRule->is_active)
                        <span class="px-3 py-1 bg-green-500/20 text-green-400 text-sm rounded-full border border-green-500/30">
                            Aktif
                        </span>
                        @else
                        <span class="px-3 py-1 bg-gray-500/20 text-gray-400 text-sm rounded-full border border-gray-500/30">
                            Nonaktif
                        </span>
                        @endif
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Priority</span>
                        <span class="text-white">{{ $automationRule->priority }}</span>
                    </div>
                </div>
            </div>

            <!-- Trigger Event -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Trigger Event</h3>
                <div class="bg-white/5 rounded-lg p-4">
                    <code class="text-blue-400 font-mono text-sm">{{ $automationRule->trigger_event }}</code>
                </div>
            </div>

            <!-- Conditions -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Conditions</h3>
                <div class="bg-white/5 rounded-lg p-4">
                    <pre class="text-gray-300 font-mono text-sm overflow-x-auto">{{ json_encode($automationRule->conditions, JSON_PRETTY_PRINT) }}</pre>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Actions</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach($automationRule->actions as $action)
                    <span class="px-3 py-1 bg-green-500/20 text-green-400 text-sm rounded border border-green-500/30">
                        {{ $action }}
                    </span>
                    @endforeach
                </div>
                @if($automationRule->action_params)
                <div class="mt-4">
                    <p class="text-gray-400 text-sm mb-2">Action Parameters:</p>
                    <div class="bg-white/5 rounded-lg p-4">
                        <pre class="text-gray-300 font-mono text-sm overflow-x-auto">{{ json_encode($automationRule->action_params, JSON_PRETTY_PRINT) }}</pre>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Statistics -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Statistics</h3>
                <div class="space-y-4">
                    <div>
                        <p class="text-gray-400 text-sm">Total Executions</p>
                        <p class="text-2xl font-bold text-white">{{ $automationRule->execution_count }}</p>
                    </div>
                    @if($automationRule->last_executed_at)
                    <div>
                        <p class="text-gray-400 text-sm">Last Executed</p>
                        <p class="text-white">{{ $automationRule->last_executed_at->format('d/m/Y H:i:s') }}</p>
                        <p class="text-gray-500 text-xs">{{ $automationRule->last_executed_at->diffForHumans() }}</p>
                    </div>
                    @else
                    <div>
                        <p class="text-gray-400 text-sm">Last Executed</p>
                        <p class="text-gray-500">Never</p>
                    </div>
                    @endif
                    <div>
                        <p class="text-gray-400 text-sm">Created</p>
                        <p class="text-white text-sm">{{ $automationRule->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-gray-400 text-sm">Updated</p>
                        <p class="text-white text-sm">{{ $automationRule->updated_at->format('d/m/Y H:i') }}</p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Actions</h3>
                <div class="space-y-2">
                    <a href="{{ route('automation-rules.edit', $automationRule) }}" 
                       class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                        Edit Rule
                    </a>
                    <form action="{{ route('automation-rules.destroy', $automationRule) }}" method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus rule ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="block w-full bg-red-600 hover:bg-red-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                            Hapus Rule
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

