@extends('layouts.app')

@section('title', 'Call Records')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Call Records</h2>
            <p class="text-gray-400 text-sm mt-1">Rekaman panggilan masuk dari telepon 110</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-surface border border-border rounded-xl p-4 mb-6">
        <form method="GET" action="{{ route('call-records.index') }}" class="flex gap-4 flex-wrap">
            <select name="status" class="bg-white/5 border border-white/10 rounded-lg px-3 py-2 text-sm text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Semua Status</option>
                <option value="ringing" {{ request('status') == 'ringing' ? 'selected' : '' }}>Ringing</option>
                <option value="answered" {{ request('status') == 'answered' ? 'selected' : '' }}>Answered</option>
                <option value="ended" {{ request('status') == 'ended' ? 'selected' : '' }}>Ended</option>
                <option value="missed" {{ request('status') == 'missed' ? 'selected' : '' }}>Missed</option>
                <option value="busy" {{ request('status') == 'busy' ? 'selected' : '' }}>Busy</option>
                <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>Failed</option>
            </select>
            <input type="text" name="caller_id" value="{{ request('caller_id') }}" 
                   placeholder="Cari nomor penelpon..." 
                   class="bg-white/5 border border-white/10 rounded-lg px-3 py-2 text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Filter
            </button>
            <a href="{{ route('call-records.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
                Reset
            </a>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-surface border border-border rounded-xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-white/5">
                <thead class="bg-white/5">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Call ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Caller ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Called Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Duration</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Started At</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Location</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-surface divide-y divide-white/5">
                    @forelse($callRecords as $callRecord)
                    <tr class="hover:bg-white/5 transition">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm font-mono text-gray-300">{{ $callRecord->call_id }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-white">{{ $callRecord->caller_id ?? '-' }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">{{ $callRecord->called_number ?? '110' }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $statusColors = [
                                    'ringing' => 'bg-yellow-500/20 text-yellow-400 border-yellow-500/30',
                                    'answered' => 'bg-blue-500/20 text-blue-400 border-blue-500/30',
                                    'ended' => 'bg-green-500/20 text-green-400 border-green-500/30',
                                    'missed' => 'bg-red-500/20 text-red-400 border-red-500/30',
                                    'busy' => 'bg-orange-500/20 text-orange-400 border-orange-500/30',
                                    'failed' => 'bg-red-500/20 text-red-400 border-red-500/30',
                                ];
                                $color = $statusColors[$callRecord->status] ?? 'bg-gray-500/20 text-gray-400 border-gray-500/30';
                            @endphp
                            <span class="px-2 py-1 text-xs rounded-full border {{ $color }}">
                                {{ ucfirst($callRecord->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">
                                @if($callRecord->duration)
                                    {{ gmdate('i:s', $callRecord->duration) }}
                                @else
                                    -
                                @endif
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">{{ $callRecord->started_at?->format('d/m/Y H:i:s') ?? '-' }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">
                                {{ $callRecord->location->address ?? ($callRecord->location->district ?? '-') }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <a href="{{ route('call-records.show', $callRecord) }}" 
                               class="text-blue-400 hover:text-blue-300 transition">Detail</a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="px-6 py-8 text-center text-gray-400">
                            <div class="flex flex-col items-center gap-2">
                                <i data-lucide="phone-off" class="w-12 h-12 text-gray-600"></i>
                                <p>Tidak ada call records</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if(method_exists($callRecords, 'links'))
    <div class="mt-4">
        {{ $callRecords->links() }}
    </div>
    @endif
</div>

@push('scripts')
<script>
    if (window.lucide) {
        lucide.createIcons();
    }
</script>
@endpush
@endsection

