@extends('layouts.app')

@section('title', 'Call Record Detail')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Call Record Detail</h2>
            <p class="text-gray-400 text-sm mt-1">Detail rekaman panggilan</p>
        </div>
        <a href="{{ route('call-records.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Call Information -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Informasi Panggilan</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Call ID</span>
                        <span class="text-white font-mono text-sm">{{ $callRecord->call_id }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Caller ID</span>
                        <span class="text-white">{{ $callRecord->caller_id ?? '-' }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Called Number</span>
                        <span class="text-white">{{ $callRecord->called_number ?? '110' }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Status</span>
                        @php
                            $statusColors = [
                                'ringing' => 'bg-yellow-500/20 text-yellow-400 border-yellow-500/30',
                                'answered' => 'bg-blue-500/20 text-blue-400 border-blue-500/30',
                                'ended' => 'bg-green-500/20 text-green-400 border-green-500/30',
                                'missed' => 'bg-red-500/20 text-red-400 border-red-500/30',
                                'busy' => 'bg-orange-500/20 text-orange-400 border-orange-500/30',
                                'failed' => 'bg-red-500/20 text-red-400 border-red-500/30',
                            ];
                            $color = $statusColors[$callRecord->status] ?? 'bg-gray-500/20 text-gray-400 border-gray-500/30';
                        @endphp
                        <span class="px-3 py-1 text-sm rounded-full border {{ $color }}">
                            {{ ucfirst($callRecord->status) }}
                        </span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Duration</span>
                        <span class="text-white">
                            @if($callRecord->duration)
                                {{ gmdate('H:i:s', $callRecord->duration) }}
                            @else
                                -
                            @endif
                        </span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Channel</span>
                        <span class="text-white font-mono text-sm">{{ $callRecord->channel ?? '-' }}</span>
                    </div>
                </div>
            </div>

            <!-- Timeline -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Timeline</h3>
                <div class="space-y-4">
                    <div class="flex items-start gap-4">
                        <div class="w-2 h-2 rounded-full bg-blue-500 mt-2"></div>
                        <div>
                            <p class="text-white font-medium">Started</p>
                            <p class="text-gray-400 text-sm">{{ $callRecord->started_at?->format('d/m/Y H:i:s') ?? '-' }}</p>
                        </div>
                    </div>
                    @if($callRecord->answered_at)
                    <div class="flex items-start gap-4">
                        <div class="w-2 h-2 rounded-full bg-green-500 mt-2"></div>
                        <div>
                            <p class="text-white font-medium">Answered</p>
                            <p class="text-gray-400 text-sm">{{ $callRecord->answered_at->format('d/m/Y H:i:s') }}</p>
                        </div>
                    </div>
                    @endif
                    @if($callRecord->ended_at)
                    <div class="flex items-start gap-4">
                        <div class="w-2 h-2 rounded-full bg-red-500 mt-2"></div>
                        <div>
                            <p class="text-white font-medium">Ended</p>
                            <p class="text-gray-400 text-sm">{{ $callRecord->ended_at->format('d/m/Y H:i:s') }}</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Location -->
            @if($callRecord->location)
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Lokasi</h3>
                <div class="space-y-2">
                    <p class="text-white">{{ $callRecord->location->address ?? '-' }}</p>
                    <p class="text-gray-400 text-sm">
                        {{ $callRecord->location->district ?? '' }}
                        {{ $callRecord->location->regency ? ', ' . $callRecord->location->regency : '' }}
                        {{ $callRecord->location->province ? ', ' . $callRecord->location->province : '' }}
                    </p>
                    <p class="text-gray-500 text-xs font-mono">
                        {{ $callRecord->location->latitude }}, {{ $callRecord->location->longitude }}
                    </p>
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Related Complaint -->
            @if($callRecord->complaint)
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Related Complaint</h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-gray-400 text-sm">Ticket Number</p>
                        <p class="text-white font-mono">{{ $callRecord->complaint->ticket_number }}</p>
                    </div>
                    <div>
                        <p class="text-gray-400 text-sm">Status</p>
                        <span class="px-2 py-1 text-xs rounded-full bg-blue-500/20 text-blue-400 border border-blue-500/30">
                            {{ ucfirst($callRecord->complaint->status) }}
                        </span>
                    </div>
                    <a href="{{ route('complaints.show', $callRecord->complaint) }}" 
                       class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                        Lihat Complaint
                    </a>
                </div>
            </div>
            @endif

            <!-- Recording -->
            @php
                $recording = \App\Models\ComplaintRecording::where('recording_id', $callRecord->call_id)->first();
            @endphp
            @if($recording)
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Recording</h3>
                @php
                    $recordingService = app(\App\Services\RecordingService::class);
                    $recordingUrl = $recordingService->getRecordingUrl($recording);
                @endphp
                <audio controls class="w-full">
                    <source src="{{ $recordingUrl }}" type="audio/mpeg">
                    Your browser does not support the audio element.
                </audio>
                <div class="mt-3 text-xs text-gray-500">
                    <p>Duration: {{ $recording->duration ?? '-' }}</p>
                    <p>Source: {{ ucfirst($recording->source) }}</p>
                </div>
            </div>
            @elseif($callRecord->recording_path)
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Recording</h3>
                <p class="text-gray-400 text-sm">Recording path: {{ $callRecord->recording_path }}</p>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

