@extends('layouts.app')

@section('title', 'Daftar CCTV')

@section('content')
<div>
    <h2 class="text-3xl font-bold mb-6">Daftar CCTV</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nama</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Sumber</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Lokasi</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($cctvs as $cctv)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">{{ $cctv->name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $cctv->code }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ ucfirst($cctv->source) }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $cctv->address }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            {{ $cctv->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ ucfirst($cctv->status) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="{{ route('cctvs.show', $cctv) }}" class="text-blue-600 hover:text-blue-900">Detail</a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Tidak ada data CCTV</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $cctvs->links() }}
    </div>
</div>
@endsection

