@extends('layouts.app')

@section('title', 'Detail CCTV - ' . $cctv->name)

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Detail CCTV: {{ $cctv->name }}</h2>
        <a href="{{ route('cctvs.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Informasi CCTV</h3>
            <dl class="space-y-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Nama</dt>
                    <dd class="text-sm text-gray-900">{{ $cctv->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Code</dt>
                    <dd class="text-sm text-gray-900">{{ $cctv->code }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Sumber</dt>
                    <dd class="text-sm text-gray-900">{{ ucfirst($cctv->source) }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            {{ $cctv->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ ucfirst($cctv->status) }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Alamat</dt>
                    <dd class="text-sm text-gray-900">{{ $cctv->address }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Radius Coverage</dt>
                    <dd class="text-sm text-gray-900">{{ $cctv->radius_coverage }} meter</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Lokasi</h3>
            <p class="text-sm text-gray-900 mb-2">Koordinat: {{ $cctv->latitude }}, {{ $cctv->longitude }}</p>
            <div id="map" style="height: 300px; width: 100%;"></div>
        </div>
    </div>

    @if($cctv->snapshots->count() > 0)
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h3 class="text-xl font-bold mb-4">Snapshots Terbaru</h3>
        <div class="grid grid-cols-4 gap-4">
            @foreach($cctv->snapshots->take(8) as $snapshot)
            <img src="{{ $snapshot->snapshot_url }}" alt="Snapshot" class="w-full h-32 object-cover rounded">
            @endforeach
        </div>
    </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
    var map = L.map('map').setView([{{ $cctv->latitude }}, {{ $cctv->longitude }}], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
    L.marker([{{ $cctv->latitude }}, {{ $cctv->longitude }}]).addTo(map);
</script>
@endpush

