@extends('layouts.app')

@section('title', 'Tambah Aduan Baru')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Tambah Aduan Baru</h2>
        <a href="{{ route('complaints.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('complaints.store') }}" method="POST">
            @csrf
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Sumber</label>
                    <select name="source" class="w-full border rounded px-3 py-2" required>
                        <option value="phone">Telepon</option>
                        <option value="mobile_app">Mobile App</option>
                        <option value="panic_button">Panic Button</option>
                        <option value="whatsapp">WhatsApp</option>
                        <option value="sms">SMS</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Nama Pelapor</label>
                    <input type="text" name="caller_name" class="w-full border rounded px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Telepon Pelapor</label>
                    <input type="text" name="caller_phone" class="w-full border rounded px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Latitude</label>
                    <input type="number" step="any" name="latitude" class="w-full border rounded px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Longitude</label>
                    <input type="number" step="any" name="longitude" class="w-full border rounded px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Cell ID</label>
                    <input type="text" name="cell_id" class="w-full border rounded px-3 py-2">
                </div>
            </div>

            <div class="mt-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Deskripsi Aduan</label>
                <textarea name="description" rows="5" class="w-full border rounded px-3 py-2" required></textarea>
            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">
                    Simpan Aduan
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

