@extends('layouts.app')

@section('title', 'Edit Aduan - ' . $complaint->ticket_number)

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Edit Aduan: {{ $complaint->ticket_number }}</h2>
        <a href="{{ route('complaints.show', $complaint) }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('complaints.update', $complaint) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                    <select name="status" class="w-full border rounded px-3 py-2">
                        @foreach(['pending','processing','dispatched','in_progress','completed','cancelled'] as $status)
                            <option value="{{ $status }}" @selected($complaint->status === $status)>{{ ucfirst(str_replace('_',' ',$status)) }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Prioritas</label>
                    <select name="priority" class="w-full border rounded px-3 py-2">
                        @foreach(['low','medium','high','critical'] as $priority)
                            <option value="{{ $priority }}" @selected($complaint->priority === $priority)>{{ ucfirst($priority) }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mt-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Deskripsi Aduan</label>
                <textarea name="description" rows="5" class="w-full border rounded px-3 py-2">{{ old('description', $complaint->description) }}</textarea>
            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">
                    Simpan Perubahan
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

