@extends('layouts.app')

@section('title', 'Detail Aduan - ' . $complaint->ticket_number)

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Detail Aduan: {{ $complaint->ticket_number }}</h2>
        <a href="{{ route('complaints.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Complaint Details -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-xl font-bold mb-4">Informasi Aduan</h3>
                <dl class="grid grid-cols-2 gap-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Ticket Number</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $complaint->ticket_number }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Sumber</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($complaint->source) }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Kategori</dt>
                        <dd class="mt-1">
                            <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                                {{ ucfirst(str_replace('_', ' ', $complaint->category)) }}
                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Status</dt>
                        <dd class="mt-1">
                            <span class="px-2 py-1 text-xs rounded-full 
                                {{ $complaint->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                {{ $complaint->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                                {{ ucfirst($complaint->status) }}
                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Priority</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($complaint->priority) }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Waktu Diterima</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $complaint->received_at->format('d/m/Y H:i:s') }}</dd>
                    </div>
                </dl>
                <div class="mt-4">
                    <dt class="text-sm font-medium text-gray-500">Deskripsi</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $complaint->description }}</dd>
                </div>
            </div>

            <!-- Location -->
            @if($complaint->location)
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-xl font-bold mb-4">Lokasi</h3>
                <p class="text-sm text-gray-900">{{ $complaint->location->address }}</p>
                <p class="text-sm text-gray-500 mt-2">
                    Koordinat: {{ $complaint->location->latitude }}, {{ $complaint->location->longitude }}
                </p>
                <div id="map" style="height: 300px; width: 100%; margin-top: 1rem;"></div>
            </div>
            @endif

            <!-- Dispatches -->
            @if($complaint->dispatches->count() > 0)
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-xl font-bold mb-4">Dispatch</h3>
                @foreach($complaint->dispatches as $dispatch)
                <div class="border-b pb-4 mb-4 last:border-0 last:pb-0 last:mb-0">
                    <p class="font-medium">Unit: {{ ucfirst($dispatch->unit_type) }}</p>
                    <p class="text-sm text-gray-600">Status: {{ ucfirst($dispatch->status) }}</p>
                    <p class="text-sm text-gray-600">Polsek: {{ $dispatch->polsek->name }}</p>
                </div>
                @endforeach
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Caller Info -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-xl font-bold mb-4">Informasi Pelapor</h3>
                <dl class="space-y-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Nama</dt>
                        <dd class="text-sm text-gray-900">{{ $complaint->caller_name ?? '-' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Telepon</dt>
                        <dd class="text-sm text-gray-900">{{ $complaint->caller_phone ?? '-' }}</dd>
                    </div>
                </dl>
            </div>

            @auth
            <!-- Actions -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-xl font-bold mb-4">Aksi</h3>
                <div class="space-y-2">
                    <form action="{{ route('complaints.classify', $complaint) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                            Re-classify
                        </button>
                    </form>
                </div>
            </div>
            @endauth
        </div>
    </div>
</div>
@endsection

@push('scripts')
@if($complaint->location)
<script>
    var map = L.map('map').setView([{{ $complaint->location->latitude }}, {{ $complaint->location->longitude }}], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
    L.marker([{{ $complaint->location->latitude }}, {{ $complaint->location->longitude }}]).addTo(map);
</script>
@endif
@endpush

